//
//  UIColor+OLExtend.h
//  OkLine
//
//  Created by hxk on 16/10/24.
//  Copyright © 2016年 ding juanjuan. All rights reserved.
//

#import <UIKit/UIKit.h>
@interface UIColor (OLExtend)

/**
 通过16进制的字符串，返回对应的UIColor
 @param hexColorString 16进制的字符串
 @return 返回UIColor对象
 */
+ (UIColor *)ol_colorWithHexColorString:(NSString *)hexColorString;


/**
 通过16进制的字符串和给定的Alpha，返回对应的UIColor
 @param hexColorString 16进制的字符串
 @param alpha          alpha值
 @return 返回UIColor对象
 */
+ (UIColor *)ol_colorWithHexColorString:(NSString *)hexColorString alpha:(float)alpha;

@end
